/*
 * Decompiled with CFR 0.152.
 */
package cam.ladybug.script;

import cam.ladybug.script.PlayerScript;
import com.badlogic.gdx.math.Vector2;
import com.ladybug.engine.components.Collider;
import com.ladybug.engine.components.Rigidbody;
import com.ladybug.engine.components.Script;
import com.ladybug.engine.game.LayerManager;
import com.ladybug.vilain.GlobalVilain;

public class Enemies
extends Script {
    protected float jumpForce = 3.0f;
    protected boolean touched = false;
    protected boolean dead = true;
    protected float m_velocity = 0.5f;

    @Override
    public void awake() {
        this.m_object.addComponent(new Rigidbody());
    }

    @Override
    public void update() {
        if (this.touched && this.getObject().getY() < 0.0f) {
            this.die();
        }
    }

    public void pop(float _x, float _y) {
        this.getObject().setPosition(_x, _y);
        this.getRenderer().setFrame(0, 0);
        this.getRigidbody().setVelocity(new Vector2(this.m_velocity, 0.0f));
        this.getCollider().enabled = true;
        this.touched = false;
        this.dead = false;
    }

    public void die() {
        GlobalVilain.SCORE += 10.0f;
        this.getRigidbody().setVelocity(new Vector2());
        this.touched = false;
        this.dead = true;
        this.getObject().setPosition(-1000.0f, -1000.0f);
    }

    public void setDead(boolean a_dead) {
        this.dead = a_dead;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void jump() {
        if (this.getObject().rigidbody.m_onGround) {
            this.getObject().rigidbody.setAcceleration(-this.jumpForce);
            this.getObject().rigidbody.m_onGround = false;
        }
    }

    @Override
    public void OnCollisionEnter(Collider other) {
        if (other.LAYER == LayerManager.GROUND) {
            this.getRigidbody().m_onGround = true;
            this.jump();
        }
        if (other.LAYER == LayerManager.PLAYER) {
            this.getRenderer().setFrame(1, 0);
            this.getRigidbody().setVelocity(new Vector2());
            this.getObject().rigidbody.setAcceleration(-1.0f);
            this.getCollider().enabled = false;
            this.touched = true;
            PlayerScript.instance.killBullet(other.getObject());
        }
    }
}

