/*
 * Decompiled with CFR 0.152.
 */
package cam.ladybug.script;

import cam.ladybug.script.Enemies;
import cam.ladybug.script.Luigi;
import cam.ladybug.script.Mario;
import com.ladybug.engine.components.BoxCollider;
import com.ladybug.engine.components.Script;
import com.ladybug.engine.game.Scene;
import com.ladybug.engine.gameobject.GameObject;
import java.util.ArrayList;

public class EnemiesManager
extends Script {
    ArrayList<Enemies> m_marios;
    int marioCount;
    int marioDelay = 160;
    ArrayList<Enemies> m_luigis;
    int luigiCount;
    int luigiDelay = 200;
    int count = 0;
    int luigiFirst = 120;
    Scene m_scene;

    public EnemiesManager(Scene scene) {
        this.m_scene = scene;
        this.createMarios();
        this.createLuigis();
    }

    @Override
    public void update() {
        ++this.count;
        ++this.marioCount;
        if (this.marioCount > this.marioDelay) {
            this.marioCount = 0;
            this.m_marios.get(this.getFreeEnemy(this.m_marios)).pop(0.0f, 100.0f);
        }
        if (this.count > this.luigiFirst) {
            ++this.luigiCount;
            if (this.luigiCount > this.luigiDelay) {
                this.luigiCount = 0;
                this.m_luigis.get(this.getFreeEnemy(this.m_luigis)).pop(0.0f, 100.0f);
            }
        }
        if (this.count == 200) {
            this.luigiDelay -= 20;
            this.marioDelay -= 10;
        }
    }

    private void createMarios() {
        this.m_marios = new ArrayList();
        int i = 0;
        while (i < 10) {
            GameObject mario = new GameObject(-1000.0f, 100.0f, "data/mario.png", 24, 24, "Mario");
            mario.addComponent(new BoxCollider(20.0f, 20.0f));
            Mario e = new Mario();
            mario.addComponent(e);
            this.m_marios.add(e);
            this.m_scene.addObject(mario);
            e.setDead(true);
            ++i;
        }
    }

    private void createLuigis() {
        this.m_luigis = new ArrayList();
        int i = 0;
        while (i < 10) {
            GameObject luigi = new GameObject(-1000.0f, 100.0f, "data/luigi.png", 24, 24, "Luigi");
            luigi.addComponent(new BoxCollider(20.0f, 20.0f));
            Luigi e = new Luigi();
            luigi.addComponent(e);
            this.m_luigis.add(e);
            this.m_scene.addObject(luigi);
            e.setDead(true);
            ++i;
        }
    }

    private int getFreeEnemy(ArrayList<Enemies> e) {
        int i = 0;
        while (i < e.size()) {
            if (e.get(i).isDead()) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

