/*
 * Decompiled with CFR 0.152.
 */
package cam.ladybug.script;

import cam.ladybug.script.FireScript;
import com.badlogic.gdx.Gdx;
import com.ladybug.engine.components.BoxCollider;
import com.ladybug.engine.components.Collider;
import com.ladybug.engine.components.Rigidbody;
import com.ladybug.engine.components.Script;
import com.ladybug.engine.game.LayerManager;
import com.ladybug.engine.gameobject.GameObject;
import java.util.ArrayList;

public class PlayerScript
extends Script {
    public static PlayerScript instance;
    float jumpForce = 3.0f;
    ArrayList<FireScript> m_fsList;
    int m_countFire = 0;
    int m_delayFire = 40;

    public PlayerScript() {
        instance = this;
    }

    @Override
    public void awake() {
        this.getObject().addComponent(new Rigidbody());
        this.getObject().addComponent(new BoxCollider(48.0f, 48.0f));
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void update() {
        ++this.m_countFire;
        if (Gdx.input.isKeyPressed(62)) {
            this.jump();
        }
        if (Gdx.input.justTouched() && this.m_countFire >= this.m_delayFire) {
            this.m_fsList.get(this.getBullet()).shoot(this.getObject().getX() - 16.0f, this.getObject().getY() + 20.0f);
            this.m_countFire = 0;
        }
    }

    public void jump() {
        if (this.getObject().rigidbody.m_onGround) {
            this.getObject().rigidbody.setAcceleration(-this.jumpForce);
            this.getObject().rigidbody.m_onGround = false;
        }
    }

    public void setBullets(ArrayList<FireScript> fs) {
        this.m_fsList = fs;
    }

    public int getBullet() {
        int i = 0;
        while (i < this.m_fsList.size()) {
            if (this.m_fsList.get(i).isReady()) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void killBullet(GameObject go) {
        int i = 0;
        while (i < this.m_fsList.size()) {
            if (this.m_fsList.get(i).getObject().equals(go)) {
                this.m_fsList.get(i).kill();
            }
            ++i;
        }
    }

    @Override
    public void OnCollisionEnter(Collider other) {
        if (other.LAYER == LayerManager.GROUND) {
            this.getRigidbody().m_onGround = true;
        }
    }
}

