/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d.tiled;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteCache;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.tiled.SimpleTileAtlas;
import com.badlogic.gdx.graphics.g2d.tiled.TileAtlas;
import com.badlogic.gdx.graphics.g2d.tiled.TiledMap;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.IntArray;
import java.util.StringTokenizer;

public class TileMapRenderer
implements Disposable {
    private SpriteCache cache;
    private int[][][] normalCacheId;
    private int[][][] blendedCacheId;
    private TileAtlas atlas;
    private TiledMap map;
    private int mapHeightUnits;
    private int mapWidthUnits;
    private int tileWidth;
    private int tileHeight;
    private float unitsPerTileX;
    private float unitsPerTileY;
    private int tilesPerBlockX;
    private int tilesPerBlockY;
    private float unitsPerBlockX;
    private float unitsPerBlockY;
    private int[] allLayers;
    private boolean isSimpleTileAtlas = false;
    private IntArray blendedTiles;
    private static final int FLAG_FLIP_X = Integer.MIN_VALUE;
    private static final int FLAG_FLIP_Y = 0x40000000;
    private static final int FLAG_ROTATE = 0x20000000;
    private static final int MASK_CLEAR = -536870912;
    Vector3 tmp = new Vector3();
    public float overdrawX;
    public float overdrawY;
    private int initialRow;
    private int initialCol;
    private int currentRow;
    private int currentCol;
    private int lastRow;
    private int lastCol;
    private int currentLayer;

    public TileMapRenderer(TiledMap map, TileAtlas atlas, int tilesPerBlockX, int tilesPerBlockY) {
        this(map, atlas, tilesPerBlockX, tilesPerBlockY, map.tileWidth, map.tileHeight);
    }

    public TileMapRenderer(TiledMap map, TileAtlas atlas, int tilesPerBlockX, int tilesPerBlockY, float unitsPerTileX, float unitsPerTileY) {
        this(map, atlas, tilesPerBlockX, tilesPerBlockY, unitsPerTileX, unitsPerTileY, null);
    }

    public TileMapRenderer(TiledMap map, TileAtlas atlas, int tilesPerBlockX, int tilesPerBlockY, ShaderProgram shader) {
        this(map, atlas, tilesPerBlockX, tilesPerBlockY, map.tileWidth, map.tileHeight, shader);
    }

    public TileMapRenderer(TiledMap map, TileAtlas atlas, int tilesPerBlockX, int tilesPerBlockY, float unitsPerTileX, float unitsPerTileY, ShaderProgram shader) {
        int i;
        int[][][] tileMap = new int[map.layers.size()][][];
        for (i = 0; i < map.layers.size(); ++i) {
            tileMap[i] = map.layers.get((int)i).tiles;
        }
        for (i = 0; i < map.tileSets.size(); ++i) {
            if ((float)(map.tileSets.get((int)i).tileHeight - map.tileHeight) > this.overdrawY * unitsPerTileY) {
                this.overdrawY = (float)(map.tileSets.get((int)i).tileHeight - map.tileHeight) / unitsPerTileY;
            }
            if (!((float)(map.tileSets.get((int)i).tileWidth - map.tileWidth) > this.overdrawX * unitsPerTileX)) continue;
            this.overdrawX = (float)(map.tileSets.get((int)i).tileWidth - map.tileWidth) / unitsPerTileX;
        }
        String blendedTiles = map.properties.get("blended tiles");
        IntArray blendedTilesArray = blendedTiles != null ? TileMapRenderer.createFromCSV(blendedTiles) : new IntArray(0);
        this.init(tileMap, atlas, map.tileWidth, map.tileHeight, unitsPerTileX, unitsPerTileY, blendedTilesArray, tilesPerBlockX, tilesPerBlockY, shader);
        this.map = map;
    }

    public TileMapRenderer(int[][][] map, TileAtlas atlas, int tileWidth, int tileHeight, float unitsPerTileX, float unitsPerTileY, IntArray blendedTiles, int tilesPerBlockX, int tilesPerBlockY) {
        this.init(map, atlas, tileWidth, tileHeight, unitsPerTileX, unitsPerTileY, blendedTiles, tilesPerBlockX, tilesPerBlockY, null);
    }

    public TileMapRenderer(int[][][] map, TileAtlas atlas, int tileWidth, int tileHeight, float unitsPerTileX, float unitsPerTileY, IntArray blendedTiles, int tilesPerBlockX, int tilesPerBlockY, ShaderProgram shader) {
        this.init(map, atlas, tileWidth, tileHeight, unitsPerTileX, unitsPerTileY, blendedTiles, tilesPerBlockX, tilesPerBlockY, shader);
    }

    private void init(int[][][] map, TileAtlas atlas, int tileWidth, int tileHeight, float unitsPerTileX, float unitsPerTileY, IntArray blendedTiles, int tilesPerBlockX, int tilesPerBlockY, ShaderProgram shader) {
        int col;
        int row;
        int layer;
        this.atlas = atlas;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.unitsPerTileX = unitsPerTileX;
        this.unitsPerTileY = unitsPerTileY;
        this.blendedTiles = blendedTiles;
        this.tilesPerBlockX = tilesPerBlockX;
        this.tilesPerBlockY = tilesPerBlockY;
        this.unitsPerBlockX = unitsPerTileX * (float)tilesPerBlockX;
        this.unitsPerBlockY = unitsPerTileY * (float)tilesPerBlockY;
        this.isSimpleTileAtlas = atlas instanceof SimpleTileAtlas;
        this.allLayers = new int[map.length];
        int maxCacheSize = 0;
        int maxHeight = 0;
        int maxWidth = 0;
        for (layer = 0; layer < map.length; ++layer) {
            this.allLayers[layer] = layer;
            if (map[layer].length > maxHeight) {
                maxHeight = map[layer].length;
            }
            for (row = 0; row < map[layer].length; ++row) {
                if (map[layer][row].length > maxWidth) {
                    maxWidth = map[layer][row].length;
                }
                for (col = 0; col < map[layer][row].length; ++col) {
                    if (map[layer][row][col] == 0) continue;
                    ++maxCacheSize;
                }
            }
        }
        this.mapHeightUnits = (int)((float)maxHeight * unitsPerTileY);
        this.mapWidthUnits = (int)((float)maxWidth * unitsPerTileX);
        this.cache = shader == null ? new SpriteCache(maxCacheSize, false) : new SpriteCache(maxCacheSize, shader, false);
        this.normalCacheId = new int[map.length][][];
        this.blendedCacheId = new int[map.length][][];
        for (layer = 0; layer < map.length; ++layer) {
            this.normalCacheId[layer] = new int[MathUtils.ceil((float)map[layer].length / (float)tilesPerBlockY)][];
            this.blendedCacheId[layer] = new int[MathUtils.ceil((float)map[layer].length / (float)tilesPerBlockY)][];
            for (row = 0; row < this.normalCacheId[layer].length; ++row) {
                this.normalCacheId[layer][row] = new int[MathUtils.ceil((float)map[layer][row].length / (float)tilesPerBlockX)];
                this.blendedCacheId[layer][row] = new int[MathUtils.ceil((float)map[layer][row].length / (float)tilesPerBlockX)];
                for (col = 0; col < this.normalCacheId[layer][row].length; ++col) {
                    if (this.isSimpleTileAtlas) {
                        this.blendedCacheId[layer][row][col] = this.addBlock(map[layer], row, col, false);
                        continue;
                    }
                    this.normalCacheId[layer][row][col] = this.addBlock(map[layer], row, col, false);
                    this.blendedCacheId[layer][row][col] = this.addBlock(map[layer], row, col, true);
                }
            }
        }
    }

    private int addBlock(int[][] layer, int blockRow, int blockCol, boolean blended) {
        this.cache.beginCache();
        int firstCol = blockCol * this.tilesPerBlockX;
        int firstRow = blockRow * this.tilesPerBlockY;
        int lastCol = firstCol + this.tilesPerBlockX;
        int lastRow = firstRow + this.tilesPerBlockY;
        float offsetX = ((float)this.tileWidth - this.unitsPerTileX) / 2.0f;
        float offsetY = ((float)this.tileHeight - this.unitsPerTileY) / 2.0f;
        for (int row = firstRow; row < lastRow && row < layer.length; ++row) {
            for (int col = firstCol; col < lastCol && col < layer[row].length; ++col) {
                TextureRegion reg;
                boolean rotate;
                int tile = layer[row][col];
                boolean flipX = (tile & Integer.MIN_VALUE) != 0;
                boolean flipY = (tile & 0x40000000) != 0;
                boolean bl = rotate = (tile & 0x20000000) != 0;
                if ((tile &= 0x1FFFFFFF) == 0 || blended != this.blendedTiles.contains(tile) || (reg = this.atlas.getRegion(tile)) == null) continue;
                float x = (float)col * this.unitsPerTileX - offsetX;
                float y = (float)(layer.length - row - 1) * this.unitsPerTileY - offsetY;
                float width = reg.getRegionWidth();
                float height = reg.getRegionHeight();
                float originX = width * 0.5f;
                float originY = height * 0.5f;
                float scaleX = this.unitsPerTileX / (float)this.tileWidth;
                float scaleY = this.unitsPerTileY / (float)this.tileHeight;
                float rotation = 0.0f;
                int sourceX = reg.getRegionX();
                int sourceY = reg.getRegionY();
                int sourceWidth = reg.getRegionWidth();
                int sourceHeight = reg.getRegionHeight();
                if (rotate) {
                    if (flipX && flipY) {
                        rotation = -90.0f;
                        sourceX += sourceWidth;
                        sourceWidth = -sourceWidth;
                    } else if (flipX && !flipY) {
                        rotation = -90.0f;
                    } else if (flipY && !flipX) {
                        rotation = 90.0f;
                    } else if (!flipY && !flipX) {
                        rotation = -90.0f;
                        sourceY += sourceHeight;
                        sourceHeight = -sourceHeight;
                    }
                } else {
                    if (flipX) {
                        sourceX += sourceWidth;
                        sourceWidth = -sourceWidth;
                    }
                    if (flipY) {
                        sourceY += sourceHeight;
                        sourceHeight = -sourceHeight;
                    }
                }
                this.cache.add(reg.getTexture(), x, y, originX, originY, width, height, scaleX, scaleY, rotation, sourceX, sourceY, sourceWidth, sourceHeight, false, false);
            }
        }
        return this.cache.endCache();
    }

    public void render() {
        this.render(0.0f, 0.0f, this.getMapWidthUnits(), this.getMapHeightUnits());
    }

    public void render(float x, float y, float width, float height) {
        this.render(x, y, width, height, this.allLayers);
    }

    public void render(OrthographicCamera cam) {
        this.render(cam, this.allLayers);
    }

    public void render(OrthographicCamera cam, int[] layers) {
        this.getProjectionMatrix().set(cam.combined);
        this.tmp.set(0.0f, 0.0f, 0.0f);
        cam.unproject(this.tmp);
        this.render(this.tmp.x, this.tmp.y, cam.viewportWidth * cam.zoom, cam.viewportHeight * cam.zoom, layers);
    }

    public void render(float x, float y, float width, float height, int[] layers) {
        this.lastRow = (int)(((float)this.mapHeightUnits - (y - height + this.overdrawY)) / this.unitsPerBlockY);
        this.initialRow = (int)(((float)this.mapHeightUnits - (y - this.overdrawY)) / this.unitsPerBlockY);
        this.initialRow = this.initialRow > 0 ? this.initialRow : 0;
        this.lastCol = (int)((x + width + this.overdrawX) / this.unitsPerBlockX);
        this.initialCol = (int)((x - this.overdrawX) / this.unitsPerBlockX);
        this.initialCol = this.initialCol > 0 ? this.initialCol : 0;
        Gdx.gl.glBlendFunc(770, 771);
        this.cache.begin();
        if (this.isSimpleTileAtlas) {
            Gdx.gl.glEnable(3042);
            this.currentLayer = 0;
            while (this.currentLayer < layers.length) {
                this.currentRow = this.initialRow;
                while (this.currentRow <= this.lastRow && this.currentRow < this.getLayerHeightInBlocks(this.currentLayer)) {
                    this.currentCol = this.initialCol;
                    while (this.currentCol <= this.lastCol && this.currentCol < this.getLayerWidthInBlocks(this.currentLayer, this.currentRow)) {
                        this.cache.draw(this.blendedCacheId[layers[this.currentLayer]][this.currentRow][this.currentCol]);
                        ++this.currentCol;
                    }
                    ++this.currentRow;
                }
                ++this.currentLayer;
            }
        } else {
            this.currentLayer = 0;
            while (this.currentLayer < layers.length) {
                this.currentRow = this.initialRow;
                while (this.currentRow <= this.lastRow && this.currentRow < this.getLayerHeightInBlocks(this.currentLayer)) {
                    this.currentCol = this.initialCol;
                    while (this.currentCol <= this.lastCol && this.currentCol < this.getLayerWidthInBlocks(this.currentLayer, this.currentRow)) {
                        Gdx.gl.glDisable(3042);
                        this.cache.draw(this.normalCacheId[layers[this.currentLayer]][this.currentRow][this.currentCol]);
                        Gdx.gl.glEnable(3042);
                        this.cache.draw(this.blendedCacheId[layers[this.currentLayer]][this.currentRow][this.currentCol]);
                        ++this.currentCol;
                    }
                    ++this.currentRow;
                }
                ++this.currentLayer;
            }
        }
        this.cache.end();
        Gdx.gl.glDisable(3042);
    }

    private int getLayerWidthInBlocks(int layer, int row) {
        int normalCacheWidth = 0;
        if (this.normalCacheId != null && this.normalCacheId[layer] != null && this.normalCacheId[layer][row] != null) {
            normalCacheWidth = this.normalCacheId[layer][row].length;
        }
        int blendedCacheWidth = 0;
        if (this.blendedCacheId != null && this.blendedCacheId[layer] != null && this.blendedCacheId[layer][row] != null) {
            blendedCacheWidth = this.blendedCacheId[layer][row].length;
        }
        return Math.max(normalCacheWidth, blendedCacheWidth);
    }

    private int getLayerHeightInBlocks(int layer) {
        int normalCacheHeight = 0;
        if (this.normalCacheId != null && this.normalCacheId[layer] != null) {
            normalCacheHeight = this.normalCacheId[layer].length;
        }
        int blendedCacheHeight = 0;
        if (this.blendedCacheId != null && this.blendedCacheId[layer] != null) {
            blendedCacheHeight = this.blendedCacheId[layer].length;
        }
        return Math.max(normalCacheHeight, blendedCacheHeight);
    }

    public Matrix4 getProjectionMatrix() {
        return this.cache.getProjectionMatrix();
    }

    public Matrix4 getTransformMatrix() {
        return this.cache.getTransformMatrix();
    }

    public int getRow(int worldY) {
        return (int)((float)worldY / this.unitsPerTileY);
    }

    public int getCol(int worldX) {
        return (int)((float)worldX / this.unitsPerTileX);
    }

    public int getInitialRow() {
        return this.initialRow;
    }

    public int getInitialCol() {
        return this.initialCol;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public int getLastCol() {
        return this.lastCol;
    }

    public float getUnitsPerTileX() {
        return this.unitsPerTileX;
    }

    public float getUnitsPerTileY() {
        return this.unitsPerTileY;
    }

    public int getMapHeightUnits() {
        return this.mapHeightUnits;
    }

    public int getMapWidthUnits() {
        return this.mapWidthUnits;
    }

    private static int parseIntWithDefault(String string, int defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void dispose() {
        this.cache.dispose();
    }

    public TiledMap getMap() {
        return this.map;
    }

    public TileAtlas getAtlas() {
        return this.atlas;
    }

    private static IntArray createFromCSV(String values) {
        IntArray list = new IntArray(false, (values.length() + 1) / 2);
        StringTokenizer st = new StringTokenizer(values, ",");
        while (st.hasMoreTokens()) {
            list.add(Integer.parseInt(st.nextToken()));
        }
        list.shrink();
        return list;
    }
}

