/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.badlogic.gdx.utils.Timer;

public class DragScrollListener
extends DragListener {
    private ScrollPane scroll;
    private Timer.Task scrollUp;
    private Timer.Task scrollDown;

    public DragScrollListener(final ScrollPane scroll) {
        this.scroll = scroll;
        this.scrollUp = new Timer.Task(){

            @Override
            public void run() {
                scroll.setScrollY(scroll.getScrollY() - 15.0f);
            }
        };
        this.scrollDown = new Timer.Task(){

            @Override
            public void run() {
                scroll.setScrollY(scroll.getScrollY() + 15.0f);
            }
        };
    }

    @Override
    public void drag(InputEvent event, float x, float y, int pointer) {
        if (y >= this.scroll.getHeight()) {
            this.scrollDown.cancel();
            if (!this.scrollUp.isScheduled()) {
                Timer.schedule(this.scrollUp, 0.05f, 0.05f);
            }
        } else if (y < 0.0f) {
            this.scrollUp.cancel();
            if (!this.scrollDown.isScheduled()) {
                Timer.schedule(this.scrollDown, 0.05f, 0.05f);
            }
        } else {
            this.scrollUp.cancel();
            this.scrollDown.cancel();
        }
    }

    @Override
    public void dragStop(InputEvent event, float x, float y, int pointer) {
        this.scrollUp.cancel();
        this.scrollDown.cancel();
    }
}

