/*
 * Decompiled with CFR 0.152.
 */
package com.ladybug.engine.components;

import com.badlogic.gdx.math.Vector2;
import com.ladybug.engine.components.BoxCollider;
import com.ladybug.engine.components.Component;
import com.ladybug.engine.gameobject.GameObject;
import java.util.ArrayList;
import java.util.Iterator;

public class Collider
extends Component {
    protected ArrayList<Collider> m_colliders;
    public boolean enabled = true;
    public boolean isTrigger = false;
    public Vector2 min = new Vector2();
    public Vector2 max = new Vector2();
    public Type m_collType;
    public int LAYER;
    protected ArrayList<Collider> m_currentColliders;
    protected ArrayList<Collider> m_frameColliders;

    public Collider() {
        this.m_type = Component.TYPE.COLLIDER;
        this.m_frameColliders = new ArrayList();
        this.m_currentColliders = new ArrayList();
    }

    public ArrayList<Collider> collide(Collider other) {
        ArrayList<Collider> collisions = new ArrayList<Collider>();
        boolean isColliding = false;
        if (other.m_collType == Type.BOX) {
            isColliding = this.collide((BoxCollider)other);
        }
        if (!isColliding) {
            return null;
        }
        if (this.m_colliders != null) {
            int i = 0;
            while (i < this.m_colliders.size()) {
                ArrayList<Collider> childColl = this.m_colliders.get(i).collide(other);
                if (childColl != null) {
                    collisions.addAll(childColl);
                }
                ++i;
            }
        }
        if (collisions.size() == 0) {
            collisions.add(other);
        }
        return collisions;
    }

    protected boolean collide(BoxCollider other) {
        return false;
    }

    public void scale(float w, float h) {
    }

    public void addCollision(Collider other) {
        this.m_frameColliders.add(other);
    }

    public void processCollisions() {
        this.checkEnteringAndStillCollisions();
        this.checkExitingCollisions();
        this.clearBuffers();
    }

    private void checkEnteringAndStillCollisions() {
        if (this.m_frameColliders.size() > 0) {
            for (Collider c : this.m_frameColliders) {
                if (!this.m_currentColliders.contains(c)) {
                    this.m_currentColliders.add(c);
                    this.getObject().OnCollisionEnter(c);
                    continue;
                }
                this.getObject().OnCollisionStay(c);
            }
        }
    }

    private void checkExitingCollisions() {
        if (this.m_currentColliders.size() > 0) {
            Iterator<Collider> it = this.m_currentColliders.iterator();
            while (it.hasNext()) {
                Collider c = it.next();
                if (this.m_frameColliders.contains(c)) continue;
                this.getObject().OnCollisionExit(c);
                it.remove();
            }
        }
    }

    private void clearBuffers() {
        this.m_frameColliders.clear();
    }

    public float top() {
        return this.max.y;
    }

    public float bottom() {
        return this.min.y;
    }

    public float right() {
        return this.max.x;
    }

    public float left() {
        return this.min.x;
    }

    public Type getCollType() {
        return this.m_collType;
    }

    @Override
    public void setObject(GameObject go) {
        super.setObject(go);
    }

    public static enum Type {
        BOX,
        DISC;

    }
}

