/*
 * Decompiled with CFR 0.152.
 */
package com.ladybug.engine.gameobject;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.ladybug.engine.components.BoxCollider;
import com.ladybug.engine.components.Collider;
import com.ladybug.engine.components.Component;
import com.ladybug.engine.components.Rigidbody;
import com.ladybug.engine.components.Script;
import com.ladybug.engine.gameobject.Renderer;
import java.util.ArrayList;

public class GameObject
extends Sprite {
    public String m_name;
    public Vector2 m_oldPos;
    public boolean visible = true;
    protected ArrayList<Component> m_components = new ArrayList();
    public Rigidbody rigidbody;
    public Collider collider;
    public Renderer renderer;
    public GameObject parent;
    protected ArrayList<GameObject> m_children = null;
    private Vector2 m_initialPosition;

    public GameObject() {
        this.m_initialPosition = new Vector2();
        this.m_name = "GameObject";
    }

    public GameObject(float x, float y) {
        this.m_initialPosition = new Vector2(x, y);
        this.setPosition(x, y);
        this.m_name = "GameObject";
    }

    public GameObject(String name) {
        this.m_initialPosition = new Vector2();
        this.m_name = name;
    }

    public GameObject(float x, float y, String name) {
        this.m_initialPosition = new Vector2(x, y);
        this.setPosition(x, y);
        this.m_name = name;
    }

    public GameObject(float x, float y, String textureName, int frameWidth, int frameHeight, String name) {
        this.m_initialPosition = new Vector2(x, y);
        this.setPosition(x, y);
        this.m_name = name;
        this.addComponent(new Renderer(textureName, frameWidth, frameHeight));
    }

    public void OnCollisionEnter(Collider collider) {
        if (this.m_components != null) {
            int i = 0;
            while (i < this.m_components.size()) {
                Component c = this.m_components.get(i);
                if (c.enabled && c.getType() == Component.TYPE.SCRIPT) {
                    ((Script)c).OnCollisionEnter(collider);
                }
                ++i;
            }
        }
    }

    public void OnCollisionStay(Collider collider) {
        if (this.m_components != null) {
            int i = 0;
            while (i < this.m_components.size()) {
                Component c = this.m_components.get(i);
                if (c.enabled && c.getType() == Component.TYPE.SCRIPT) {
                    ((Script)c).OnCollisionStay(collider);
                }
                ++i;
            }
        }
    }

    public void OnCollisionExit(Collider collider) {
        if (this.m_components != null) {
            int i = 0;
            while (i < this.m_components.size()) {
                Component c = this.m_components.get(i);
                if (c.enabled && c.getType() == Component.TYPE.SCRIPT) {
                    ((Script)c).OnCollisionExit(collider);
                }
                ++i;
            }
        }
    }

    public void updateCollider() {
        if (this.m_children == null) {
            return;
        }
        if (this.collider == null) {
            this.addComponent(new BoxCollider());
        }
        Vector2 min = this.m_children.get((int)0).collider.min;
        Vector2 max = this.m_children.get((int)0).collider.max;
        int i = 1;
        while (i < this.m_children.size()) {
            GameObject go = this.m_children.get(i);
            if (go.collider.min.x < min.x) {
                min.x = go.collider.min.x;
            }
            if (go.collider.min.y < min.y) {
                min.y = go.collider.min.y;
            }
            if (go.collider.max.x > max.x) {
                max.x = go.collider.max.x;
            }
            if (go.collider.max.x > max.x) {
                max.x = go.collider.max.x;
            }
            ++i;
        }
        this.collider.min = min;
        this.collider.max = max;
        if (this.parent != null) {
            this.parent.updateCollider();
        }
    }

    @Override
    public void draw(SpriteBatch batch) {
        if (!this.visible) {
            return;
        }
        if (this.getTexture() != null) {
            super.draw(batch);
        }
        if (this.m_children != null) {
            int i = 0;
            while (i < this.m_children.size()) {
                this.m_children.get(i).draw(batch);
                ++i;
            }
        }
    }

    public void loadAssets() {
        this.loadChildrenAssets();
        if (this.renderer != null) {
            this.renderer.loadAssets();
        }
    }

    public void bindAssets() {
        if (this.renderer != null) {
            this.renderer.loadSprite();
        }
        this.bindChildrenAssets();
    }

    private void loadChildrenAssets() {
        if (this.m_children != null) {
            int i = 0;
            while (i < this.m_children.size()) {
                this.m_children.get(i).loadAssets();
                ++i;
            }
        }
    }

    private void bindChildrenAssets() {
        if (this.m_children != null) {
            int i = 0;
            while (i < this.m_children.size()) {
                this.m_children.get(i).bindAssets();
                ++i;
            }
        }
    }

    public void replaceToOldPosition() {
        this.setPosition(this.m_oldPos.x, this.m_oldPos.y);
    }

    public void replaceToOldPositionX() {
        this.setPosition(this.m_oldPos.x, this.getY());
    }

    public void replaceToOldPositionY() {
        this.setPosition(this.getX(), this.m_oldPos.y);
    }

    public Vector2 getDeltaDir() {
        return new Vector2(this.getX() - this.m_oldPos.x, this.getY() - this.m_oldPos.y);
    }

    public void die() {
    }

    public void dispose() {
        if (this.getTexture() != null) {
            this.getTexture().dispose();
        }
    }

    public void addComponent(Component component) {
        this.m_components.add(component);
        component.setObject(this);
        Component.TYPE type = component.getType();
        if (type == Component.TYPE.RIGIDBODY) {
            this.rigidbody = (Rigidbody)component;
        } else if (type == Component.TYPE.COLLIDER) {
            this.collider = (Collider)component;
        } else if (type == Component.TYPE.RENDERER) {
            this.renderer = (Renderer)component;
        }
    }

    public void addChild(GameObject go) {
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(go);
        go.parent = this;
    }

    public void addChild(GameObject go, float x, float y, float w, float h) {
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        go.setScale(w, h);
        go.setPosition(x, y);
        if (go.collider != null) {
            go.collider.scale(w, h);
        }
        this.m_children.add(go);
        go.parent = this;
    }

    public void reset() {
        this.setPosition(this.m_initialPosition.x, this.m_initialPosition.y);
        if (this.m_components != null) {
            int i = 0;
            while (i < this.m_components.size()) {
                this.m_components.get(i).reset();
                ++i;
            }
        }
    }

    public Vector2 getPosition() {
        return new Vector2(this.getX(), this.getY());
    }

    public ArrayList<GameObject> getChildren() {
        return this.m_children;
    }

    public ArrayList<GameObject> getAllObjects() {
        ArrayList<GameObject> GOs = new ArrayList<GameObject>();
        if (this.m_children != null) {
            int i = 0;
            while (i < this.m_children.size()) {
                GOs.addAll(this.m_children.get(i).getAllObjects());
                ++i;
            }
        }
        GOs.add(this);
        return GOs;
    }

    public void coreAwake() {
        int i;
        if (this.m_children != null) {
            i = 0;
            while (i < this.m_children.size()) {
                this.m_children.get(i).coreAwake();
                ++i;
            }
        }
        if (this.m_components != null) {
            i = 0;
            while (i < this.m_components.size()) {
                if (this.m_components.get((int)i).enabled) {
                    this.m_components.get(i).awake();
                }
                ++i;
            }
        }
    }

    public void coreStart() {
        int i;
        if (this.m_children != null) {
            i = 0;
            while (i < this.m_children.size()) {
                this.m_children.get(i).coreStart();
                ++i;
            }
        }
        if (this.m_components != null) {
            i = 0;
            while (i < this.m_components.size()) {
                if (this.m_components.get((int)i).enabled) {
                    this.m_components.get(i).start();
                }
                ++i;
            }
        }
    }

    public void corePreUpdate() {
        int i;
        this.m_oldPos = this.getPosition();
        if (this.m_children != null) {
            i = 0;
            while (i < this.m_children.size()) {
                this.m_children.get(i).corePreUpdate();
                ++i;
            }
        }
        if (this.m_components != null) {
            i = 0;
            while (i < this.m_components.size()) {
                if (this.m_components.get((int)i).enabled) {
                    this.m_components.get(i).preUpdate();
                }
                ++i;
            }
        }
    }

    public void coreUpdate() {
        int i;
        if (this.m_children != null) {
            i = 0;
            while (i < this.m_children.size()) {
                this.m_children.get(i).coreUpdate();
                ++i;
            }
        }
        if (this.m_components != null) {
            i = 0;
            while (i < this.m_components.size()) {
                if (this.m_components.get((int)i).enabled) {
                    this.m_components.get(i).update();
                }
                ++i;
            }
        }
    }

    public void corePostUpdate() {
        int i;
        if (this.m_children != null) {
            i = 0;
            while (i < this.m_children.size()) {
                this.m_children.get(i).corePostUpdate();
                ++i;
            }
        }
        if (this.m_components != null) {
            i = 0;
            while (i < this.m_components.size()) {
                if (this.m_components.get((int)i).enabled) {
                    this.m_components.get(i).postUpdate();
                }
                ++i;
            }
        }
    }
}

